using UnityEngine;
using System.Collections;

public class s_Fly : MonoBehaviour 
{
	void Start()
	{
		
	}
	
	//If you hit the player, check if you win, then destroy self
	void OnTriggerStay(Collider other)
	{
		if (other.gameObject.name == "Player")
		{
			GameObject player = GameObject.Find("Player");
			s_Player playerScript = player.GetComponent<s_Player>();
			if (!playerScript.moving)
			{
				//If this is the last fly, you win
				GameObject[] flys = GameObject.FindGameObjectsWithTag("Fly");
				if (flys.Length == 1)
					playerScript.enabled = false;
				
				s_Controller controller = Camera.main.GetComponent<s_Controller>();
				controller.UpdateUIFly(1);
				
				AudioManager.PlaySound(AudioManager.getFly);
				Destroy(gameObject);
			}
		}
	}
	
	public void Tongue(bool xDir)
	{
		GameObject player = GameObject.Find("Player");
		GameObject tongue = GameObject.Find("Tongue");
		s_Tongue tongueScript = tongue.GetComponent<s_Tongue>();
		
		//Rotates the tongue to the right direction
		if (xDir)
			tongue.transform.localRotation = Quaternion.Euler(0, 0, 0);
		else
			tongue.transform.localRotation = Quaternion.Euler(0, 90, 0);
		
		//Get direction
		Vector3 dir = transform.position;
		dir.y = 0;
		dir = Vector3.Normalize(dir - player.transform.position); 
		
		//Set up tongue
		tongueScript.flyPos = transform.position; //This may change if it hits another fly!
		tongueScript.direction = dir;
		tongue.renderer.enabled = true;
		AudioManager.PlaySound(AudioManager.tongueOut, 4.5f);
	}
}
